#include "MAC57D54H.h"
#include "halo_ports.h"

void SDRAM_setup(void);


void SDRAM_setup()
{
  uint32_t i;
  
  MC_CGM.SC_DC0.R = 0x80010000; /* set DDR/SDR div to 2 */ 
  *(uint32_t *) 0x400D4400 = 0x80030000; /* Div by 4 to give /2 clock */

    /* numbers based on simulations */
    MDDRC.SYS_CONFIG.R = 0xaa800300; /* enable */
	
	SIUL2.MSCR[131].R = 0x32000001; 
	SIUL2.MSCR[130].R = 0x32000001;
	SIUL2.MSCR[129].R = 0x32000001;
	SIUL2.MSCR[128].R = 0x32000001;
	SIUL2.MSCR[166].R = 0x32000001;
	SIUL2.MSCR[165].R = 0x32000001;
	SIUL2.MSCR[164].R = 0x32000001;
	SIUL2.MSCR[163].R = 0x32000001;
	SIUL2.MSCR[162].R = 0x32000001;
	SIUL2.MSCR[161].R = 0x32000001;
	SIUL2.MSCR[132].R = 0x32000001;
	SIUL2.MSCR[160].R = 0x32000001;
	SIUL2.MSCR[159].R = 0x32000001;
	SIUL2.MSCR[134].R = 0x32000001;
	SIUL2.MSCR[133].R = 0x32000001;
	SIUL2.MSCR[137].R = 0x32000001;
	SIUL2.MSCR[158].R = 0x32000001;
	SIUL2.MSCR[157].R = 0x32000001;
	SIUL2.MSCR[135].R = 0x32000001;
	SIUL2.MSCR[147].R = 0x32080001;
	SIUL2.MSCR[146].R = 0x32080001;
	SIUL2.MSCR[145].R = 0x32080001;
	SIUL2.MSCR[144].R = 0x32080001;
	SIUL2.MSCR[143].R = 0x32080001;
	SIUL2.MSCR[142].R = 0x32080001;
	SIUL2.MSCR[141].R = 0x32080001;
	SIUL2.MSCR[140].R = 0x32080001;
	SIUL2.MSCR[155].R = 0x32080001;
	SIUL2.MSCR[154].R = 0x32080001;
	SIUL2.MSCR[153].R = 0x32080001;
	SIUL2.MSCR[152].R = 0x32080001;
	SIUL2.MSCR[151].R = 0x32080001;
	SIUL2.MSCR[150].R = 0x32080001;
	SIUL2.MSCR[149].R = 0x32080001;
	SIUL2.MSCR[148].R = 0x32080001;
	SIUL2.MSCR[156].R = 0x32000001;
	SIUL2.MSCR[139].R = 0x32000001;
	SIUL2.MSCR[136].R = 0x32000001;
	SIUL2.MSCR[138].R = 0x32000001;

	SIUL2.MSCR[358].R = 0x22080000; /* DDR_SDR_DUMMY1 */
	SIUL2.MSCR[359].R   = 0x22080000; /* DDR_SDR_DUMMY2 */

	
	MDDRC.DQS_CFG_OFF.R =  0x00000000;
	MDDRC.DQS_CFG.R =  0x00000000;

    //MDDRC.SYS_CONFIG.R = 0xf4002100;  	
    MDDRC.SYS_CONFIG.R = 0xF2E02100;    //for ISSI
	MDDRC.TIME_CONFIG0.R = 0x01f4281e; 
    MDDRC.TIME_CONFIG1.R = 0xfeab1127; 
    MDDRC.TIME_CONFIG2.R = 0x38e42064; 
    MDDRC.EX_AT.R = 0x33C00000; /* enabled SDR mode - CAS = 3 */	
	
	/* startup routine */
    //Issue 1 NOP operation while waiting 100 us since clock is stable.
    for(i=0; i<100; i++)
	MDDRC.CMD.R = 0x00380000; 	/* Issue NOP */

    for(i=0; i<20; i++)
    MDDRC.CMD.R = 0x00100400;	/* Precharge All */
    MDDRC.CMD.R = 0x00080000;	/* Issue an AUTO REFRESH */

    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */
    MDDRC.CMD.R = 0x00080000;	/* Issue an AUTO REFRESH */

    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */
	
    MDDRC.CMD.R = 0x00000033;	/* load mode register - CAS=3, burst length = 4 */
    
    for(i=0; i<20; i++)
	MDDRC.CMD.R = 0x00380000;	/* Issue NOP */

    
    MDDRC.SYS_CONFIG.R &= 0xEFFFFFFF;	/* End Command */
} /* SDRAM_setup */
